#ifndef ROBOT_H_
#define ROBOT_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"
#include "Coordinate.h"

/* Exported function prototypes ----------------------------------------------*/

// Robot_Init()
// ------------
// Initialise the robot module.
// Initialises the underlying servos module.
extern void Robot_Init();

// Robot_BeginCalibration()
// ------------------------
// Start the continuous reading of the ADC values from the servo calibration trimpots.
extern void Robot_BeginCalibration();

// Robot_UpdateCalibration()
// -------------------------
// Sets all servos to a known angle so that the servo calibration parameters can
// be correctly adjusted.
extern void Robot_UpdateCalibration();

// Robot_EndCalibration()
// ----------------------
// Stop the ADC conversions and leave the servo calibration parameters in a fixed state.
extern void Robot_EndCalibration();

// Robot_SetPosition()
// -------------------
// Sets the absolute position of the robot end actuator.
// The calculation of the individual servo angles is done in Robot_Calculate().
extern void Robot_SetPosition(const Coordinate_Absolute absoluteCoordinate);

// Robot_Calculate()
// -----------------
// Calculates the required servo angles to position the robot end actuator.
extern bool Robot_Calculate();

#endif /* ROBOT_H_ */
